/* !!! XXX DOES NOT USE BUILT-IN DETECTION XXX !!! 
alert tcp $EXTERNAL_NET $HTTP_PORTS -> $HOME_NET any (msg:"WEB-CLIENT PowerPoint malformed RecolorInfoAtom exploit attempt"; flow:to_client,established; flowbits:isset,file.ppt; content:"|0f 00 11 f0|"; content:"|00 00 e7 0f|"; within:100; reference:cve,2011-1270; reference:url,technet.microsoft.com/en-us/security/bulletin/MS11-036; classtype:attempted-user; sid:18949;)
*/
/*
 * Vuln Title: XXXX
 *
 * Copyright (C) 2005-2010 Sourcefire, Inc. All Rights Reserved
 *
 * Written by XXXX, Sourcefire VRT <XXXX@sourcefire.com>
 *
 * Auto-generated by XXXX
 *
 * This file may contain proprietary rules that were created, tested and
 * certified by Sourcefire, Inc. (the "VRT Certified Rules") as well as
 * rules that were created by Sourcefire and other third parties and
 * distributed under the GNU General Public License (the "GPL Rules").  The
 * VRT Certified Rules contained in this file are the property of
 * Sourcefire, Inc. Copyright 2005 Sourcefire, Inc. All Rights Reserved.
 * The GPL Rules created by Sourcefire, Inc. are the property of
 * Sourcefire, Inc. Copyright 2002-2005 Sourcefire, Inc. All Rights
 * Reserved.  All other GPL Rules are owned and copyrighted by their
 * respective owners (please see www.snort.org/contributors for a list of
 * owners and their respective copyrights).  In order to determine what
 * rules are VRT Certified Rules or GPL Rules, please refer to the VRT
 * Certified Rules License Agreement.
 */

#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"

//#define DEBUG 1
#ifdef DEBUG
#define DEBUG_SO(code) code
#else
#define DEBUG_SO(code)
#endif

/* declare detection functions */
int rule18949eval(void *p);

/* declare rule data structures */
/* flow:established, to_client; */
static FlowFlags rule18949flow0 = 
{
    FLOW_ESTABLISHED|FLOW_TO_CLIENT
};

static RuleOption rule18949option0 =
{
    OPTION_TYPE_FLOWFLAGS,
    {
        &rule18949flow0
    }
};
/* flowbits:isset "file.ppt"; */
static FlowBitsInfo rule18949flowbits1 =
{
    "file.ppt",
    FLOWBIT_ISSET,
    0,
};

static RuleOption rule18949option1 =
{
    OPTION_TYPE_FLOWBIT,
    {
        &rule18949flowbits1
    }
};
// content:"|0F 00 11 F0|", depth 0, fast_pattern; 
static ContentInfo rule18949content2 = 
{
    (u_int8_t *) "|0F 00 11 F0|", /* pattern (now in snort content format) */
    0, /* depth */
    0, /* offset */
    CONTENT_FAST_PATTERN|CONTENT_BUF_NORMALIZED|CONTENT_RELATIVE, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule18949option2 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule18949content2
    }
};
// content:"|00 00 E7 0F|", offset 0, depth 100, relative; 
static ContentInfo rule18949content3 = 
{
    (u_int8_t *) "|00 00 E7 0F|", /* pattern (now in snort content format) */
    100, /* depth */
    0, /* offset */
    CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule18949option3 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule18949content3
    }
};

/* references for sid 18949 */
/* reference: cve "2011-1270"; */
static RuleReference rule18949ref1 = 
{
    "cve", /* type */
    "2011-1270" /* value */
};

/* reference: url "technet.microsoft.com/en-us/security/bulletin/MS11-036"; */
static RuleReference rule18949ref2 = 
{
    "url", /* type */
    "technet.microsoft.com/en-us/security/bulletin/MS11-036" /* value */
};

static RuleReference *rule18949refs[] =
{
    &rule18949ref1,
    &rule18949ref2,
    NULL
};
/* metadata for sid 18949 */
/* metadata:; */
static RuleMetaData rule18949service1 =
{
   "service http"
};


static RuleMetaData *rule18949metadata[] =
{
    &rule18949service1,
    NULL
};

RuleOption *rule18949options[] =
{
    &rule18949option0,
    &rule18949option1,
    &rule18949option2,
    &rule18949option3,
    NULL
};

Rule rule18949 = {
   /* rule header, akin to => tcp any any -> any any */
   {
       IPPROTO_TCP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "$HTTP_PORTS", /* SRCPORT   */
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
       "any", /* DSTPORT   */
   },
   /* metadata */
   { 
       3,  /* genid */
       18949, /* sigid */
       4, /* revision */
       "attempted-user", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "WEB-CLIENT PowerPoint malformed RecolorInfoAtom exploit attempt",     /* message */
       rule18949refs /* ptr to references */
       ,rule18949metadata
   },
   rule18949options, /* ptr to rule options */
   &rule18949eval, /* DOES NOT use the built in detection function */
   0 /* am I initialized yet? */
};


/* detection functions */
// #if 0 // Don't compile the detection functions if they're not used
int rule18949eval(void *p) {
   const u_int8_t *cursor_normal = 0;
   SFSnortPacket *sp = (SFSnortPacket *) p;

   const u_int8_t *end_of_payload, *cursor_detect;

   u_int32_t header_len;
   u_int16_t cColors, cFills;

   DEBUG_SO(printf("rule18949eval enter\n");)

   if(sp == NULL)
      return RULE_NOMATCH;

   if(sp->payload == NULL)
      return RULE_NOMATCH;
   
   // flow:established, to_client;
   if(checkFlow(p, rule18949options[0]->option_u.flowFlags) <= 0)
      return RULE_NOMATCH;

   if(processFlowbits(p, rule18949options[1]->option_u.flowBit) <= 0)
      return RULE_NOMATCH;

   DEBUG_SO(printf("rule18949eval flowbit passed\n");)

   if(getBuffer(sp, CONTENT_BUF_NORMALIZED, &cursor_normal, &end_of_payload) <= 0)
      return RULE_NOMATCH;

   // content:"|0F 00 11 F0|", depth 0, fast_pattern;
   while(contentMatch(p, rule18949options[2]->option_u.content, &cursor_normal) > 0) {
      DEBUG_SO(printf("rule18949eval first content passed\n");)

      cursor_detect = cursor_normal;

      // content:"|00 00 E7 0F|", offset 0, depth 100, relative;
      if(contentMatch(p, rule18949options[3]->option_u.content, &cursor_detect) > 0) {
         DEBUG_SO(printf("rule18949eval second content passed\n");)

         if(cursor_detect + 10 > end_of_payload) 
            return RULE_NOMATCH;

         header_len = *cursor_detect++;
         header_len |= *cursor_detect++ << 8;
         header_len |= *cursor_detect++ << 16;
         header_len |= *cursor_detect++ << 24;

         cursor_detect += 2; // Skip flags

         cColors = *cursor_detect++;
         cColors |= *cursor_detect++ << 8;

         cFills = *cursor_detect++;
         cFills |= *cursor_detect++ << 8;

         DEBUG_SO(printf("header_len = 0x%04x, cColors = 0x%02x, cFills = 0x%02x\n", header_len, cColors, cFills);)

         // Int overflow not possible.  Max value 0x57FFB4
         if(header_len < (0x0c + (cColors + cFills) * 0x2c))
            return RULE_MATCH;
      }
   }
   return RULE_NOMATCH;
}
// #endif // 0 Don't compile the detection functions if they're not used
/*
Rule *rules[] = {
    &rule18949,
    NULL
};
*/
