/*
 * Vuln Title: XXXX
 *
 * Copyright (C) 2005-2010 Sourcefire, Inc. All Rights Reserved
 *
 * Written by XXXX, Sourcefire VRT <XXXX@sourcefire.com>
 *
 * Auto-generated by XXXX
 *
 * This file may contain proprietary rules that were created, tested and
 * certified by Sourcefire, Inc. (the "VRT Certified Rules") as well as
 * rules that were created by Sourcefire and other third parties and
 * distributed under the GNU General Public License (the "GPL Rules").  The
 * VRT Certified Rules contained in this file are the property of
 * Sourcefire, Inc. Copyright 2005 Sourcefire, Inc. All Rights Reserved.
 * The GPL Rules created by Sourcefire, Inc. are the property of
 * Sourcefire, Inc. Copyright 2002-2005 Sourcefire, Inc. All Rights
 * Reserved.  All other GPL Rules are owned and copyrighted by their
 * respective owners (please see www.snort.org/contributors for a list of
 * owners and their respective copyrights).  In order to determine what
 * rules are VRT Certified Rules or GPL Rules, please refer to the VRT
 * Certified Rules License Agreement.
 */

#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"

//#define DEBUG
#ifdef DEBUG
#define DEBUG_SO(code) code
#else
#define DEBUG_SO(code)
#endif


/* declare detection functions */
int rule22089eval(void *p);

/* declare rule data structures */
/* flow:established, to_client; */
static FlowFlags rule22089flow0 = 
{
   FLOW_ESTABLISHED|FLOW_TO_CLIENT
};

static RuleOption rule22089option0 =
{
   OPTION_TYPE_FLOWFLAGS,
   {
       &rule22089flow0
   }
};
/* flowbits:isset "file.rtf"; */
static FlowBitsInfo rule22089flowbits1 =
{
   "file.rtf",
   FLOWBIT_ISSET,
   0,
};

static RuleOption rule22089option1 =
{
   OPTION_TYPE_FLOWBIT,
   {
       &rule22089flowbits1
   }
};
// content:"{|5C|listoverride|5C|", depth 0, fast_pattern; 
static ContentInfo rule22089content2 = 
{
   (u_int8_t *) "{|5C|listoverride|5C|", /* pattern (now in snort content format) */
   0, /* depth */
   0, /* offset */
   CONTENT_FAST_PATTERN|CONTENT_BUF_NORMALIZED|CONTENT_RELATIVE, /* flags */
   NULL, /* holder for boyer/moore PTR */
   NULL, /* more holder info - byteform */
   0, /* byteform length */
   0 /* increment length*/
};

static RuleOption rule22089option2 = 
{
   OPTION_TYPE_CONTENT,
   {
       &rule22089content2
   }
};

static CursorInfo rule22089cursor3 = 
{
   0,
   CONTENT_BUF_NORMALIZED
};

static RuleOption rule22089option3 = 
{
   OPTION_TYPE_FILE_DATA,
   {
      &rule22089cursor3
   }
};


/* references for sid 22089 */
/* reference: cve "2012-0183"; */
static RuleReference rule22089ref1 = 
{
   "cve", /* type */
   "2012-0183" /* value */
};

/* reference: url "technet.microsoft.com/en-us/security/bulletin/ms12-XXX"; */
static RuleReference rule22089ref2 = 
{
   "url", /* type */
   "technet.microsoft.com/en-us/security/bulletin/ms12-029" /* value */
};

static RuleReference *rule22089refs[] =
{
   &rule22089ref1,
   &rule22089ref2,
   NULL
};
/* metadata for sid 22089 */
/* metadata:service http, service imap, service pop3, policy security-ips drop; */
static RuleMetaData rule22089service1 = 
{
   "service http"
};

static RuleMetaData rule22089service2 = 
{
   "service imap"
};

static RuleMetaData rule22089service3 = 
{
   "service pop3"
};


static RuleMetaData rule22089policy1 = 
{
   "policy security-ips drop"
};


static RuleMetaData *rule22089metadata[] =
{
   &rule22089service1,
   &rule22089service2,
   &rule22089service3,
   &rule22089policy1,
   NULL
};

RuleOption *rule22089options[] =
{
   &rule22089option0,
   &rule22089option1,
   &rule22089option2,
   &rule22089option3,
   NULL
};

Rule rule22089 = {
   /* rule header, akin to => tcp any any -> any any */
   {
      IPPROTO_TCP, /* proto */
      "$EXTERNAL_NET", /* SRCIP     */
      "$FILE_DATA_PORTS", /* SRCPORT   */
      0, /* DIRECTION */
      "$HOME_NET", /* DSTIP     */
      "any", /* DSTPORT   */
   },
   /* metadata */
   { 
      3,  /* genid */
      22089, /* sigid */
      2, /* revision */
      "attempted-user", /* classification */
      0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
      "WEB-CLIENT Microsoft RTF improper listoverride nesting attempt",     /* message */
      rule22089refs /* ptr to references */
      ,rule22089metadata
   },
   rule22089options, /* ptr to rule options */
   &rule22089eval, /* use the built in detection function */
   0 /* am I initialized yet? */
};


/* detection functions */
// #if 0 // Don't compile the detection functions if they're not used
int rule22089eval(void *p) {
   const u_int8_t *cursor_normal = 0;
   SFSnortPacket *sp = (SFSnortPacket *) p;
   const u_int8_t *next_override = 0, *end_loop = 0;

   int count_curlies = 0;
   int max_loops = 5; // Limit loops to reduce performance overhead

   DEBUG_SO(fprintf(stderr, "rule22089eval enter\n");)

   if(sp == NULL)
       return RULE_NOMATCH;

   if(sp->payload == NULL)
       return RULE_NOMATCH;
   
   // flow:established, to_client;
   if(checkFlow(p, rule22089options[0]->option_u.flowFlags) <= 0)
      return RULE_NOMATCH;

   // flowbits:isset "file.rtf";
   if(processFlowbits(p, rule22089options[1]->option_u.flowBit) <= 0)
      return RULE_NOMATCH;

   // Call fileData() to get alternate decode buffer
   if(fileData(p, rule22089options[3]->option_u.cursor, &cursor_normal) <= 0) {
      DEBUG_SO(fprintf(stderr, "Move to FILE_DATA failed\n");)
      return RULE_NOMATCH;
   }

   // content:"{|5C|listoverride|5C|", depth 0, fast_pattern; relative;
   if(contentMatch(p, rule22089options[2]->option_u.content, &cursor_normal) <= 0)
      return RULE_NOMATCH;

   while(max_loops--) {
      count_curlies = 1; // Count the first curly, which is part of the content match

      // Now let's find where the next listoverride is
      next_override = cursor_normal;
      if(contentMatch(p, rule22089options[2]->option_u.content, &next_override) <= 0)
         return RULE_NOMATCH;  // There are no others; we are fine

      DEBUG_SO(fprintf(stderr, "cursor_normal=%p next_override=%p\n", cursor_normal, next_override);)

      // No need to check for end_of_buffer because contentMatch assures us
      // next_override is within the payload strlen("{\x5clistoverride\x5c"); 
      end_loop = next_override - rule22089options[2]->option_u.content->patternByteFormLength;
      while(cursor_normal < end_loop) {
         if(*cursor_normal == '{') {
            count_curlies++;
            DEBUG_SO(fprintf(stderr, "count_curlies = %d\n", count_curlies);)
         } else if(*cursor_normal == '}') {
            count_curlies--;
            DEBUG_SO(fprintf(stderr, "count_curlies = %d\n", count_curlies);)
            if(count_curlies == 0)
               break; // Not malicious; try for another listoverride tag
         }
         
         cursor_normal++; 
      }

      // If we got to the end of the loop and haven't closed
      // all of our curlies, alert
      if(cursor_normal == end_loop)
         return RULE_MATCH;

      // We already found the next match, so save some cycles.
      cursor_normal = next_override;
   }

   return RULE_NOMATCH;
}
// #endif // 0 Don't compile the detection functions if they're not used
/*
Rule *rules[] = {
   &rule22089,
   NULL
};
*/
