
`ifndef NP
	`define NP 20
`endif
`ifndef SEED
	`define SEED 1
`endif

module test ();

	reg [3:0] a;		// first operand
	reg [3:0] b;		// second operand
	reg [1:0] op;		// decoded operation selector
    wire [3:0] z;		// anode output
	
	// Initialization of pattern generation variables
	integer np = `NP;
	integer seed = `SEED;

	// Circuit under test
	// Calculator with cdbits reduced to easy simulation of the 
	// display controller
	arithmetic_unit  uut (.a(a), .b(b), .op(op),
                     .z(z));

	initial begin
		
	
		op = 2'b00;
		
		// Waveform generation
		$dumpfile("test.vcd");
		$dumpvars;
		#200
		$finish; 
		end

	always begin
		#20
		a = $random(seed);
		b = $random(seed);
		#10 op=op+1;
		end
	
endmodule