// Design: code
// Description: Digital code key
// Author: Jorge Juan <jjchico@dte.us.es>
// Copyright Universidad de Sevilla, Spain
// Date: 14-12-2011

////////////////////////////////////////////////////////////////////////////////                                                                         //
// This file is free software: you can redistribute it and/or modify it under //
// the terms of the GNU General Public License as published by the Free       //
// Software Foundation, either version 3 of the License, or (at your option)  //
// any later version. You can access a copy of the GNU General Public License //
// at <http://www.gnu.org/licenses/>.                                         //
////////////////////////////////////////////////////////////////////////////////

`timescale 1ns / 1ps

// Test bench

module test();

	reg clk = 1;		// clock
	reg reset = 0;		// reset
	reg x;		// input
	wire z;			// output

	// Module instantiation
	led uut (.clk(clk), .reset(reset), .x(x), .z(z));

	initial begin
		// Waveform generation
		$dumpfile("test.vcd");
		$dumpvars(0, test);

		// Initialization
		#5	reset = 1;
			x = 0;
		#10	reset = 0;
		#15	;
		
		// Input data
		x=1;
		#400	$finish;
	end

	// Clock generator (50 MHz)
	always
		#10	clk = ~clk;
endmodule // test
