.include "m328pdef.inc"


	
	.def	temporal = r16
	.def encender=r17
	.def contador6=r18
	

	.cseg

		.org	0
		jmp		Reset
		.org	$16	
		jmp	IntTimer ;instalacin de la rutina de interrupcion
		


Reset:
		rcall   ConfiguraES
		ldi encender $01
		clc
		clr contador6
		

Programa:					;hacer mientras (Pd[2] == 1)
		sbic	pind,0
		rjmp	Programa
		cbi portd,1            		;fin mientras. Desactiva sonido y activa interrupciones
		sei
		
LiberaTecla:
		sbis	pind,0			;	mientras (Pd[2] == 0)
		rjmp	LiberaTecla		;	fin mientras

		CLI
		cpi encender, $10
		brcc Premio			
		rjmp	Programa
Premio:         sbi portd,1      ; activar zumbador
		rjmp Programa

Fin:	rjmp	Fin				;fin




ConfiguraES:					;	sub ConfiguraES

		ldi		temporal,$ff
		out		ddrb,temporal	;		DDRB <- $FF	Puerto B como salida

		
		

		cbi ddrd,0  ; activar pin0 del puerto D como entrada
		sbi portd,0 ; resiltencia de pull-up
		sbi ddrd,1 ; activar pin 1 de puerto d como salida
		


		ldi		temporal, $f4			
		sts		ocr1ah,temporal
		ldi		temporal, $24
		sts		ocr1al,temporal	;ocr1a = $f424

		ldi		temporal, 0b00001010 
		
		sts		tccr1b,temporal

		ldi		temporal,0			;	TCNT1 <- 0		;Contador a 0 (Escribir 1 en la parte H y despus en L)

		sts		tcnt1h,temporal
		sts		tcnt1l,temporal		

		ldi		temporal,2			;	TIMSK1 <- 2		;Habilitacin de la interrupcin por comparacin
		sts		timsk1,temporal
		



		ret			;fin ConfiguraES



IntTimer:	
			
		cpi	contador6,5
		brlo	Incrementa
		clr contador
		SEC
		rol encender
		call Representa
		reti
Incrementa:     inc contador
		clc
		rol encender
                call Representa
		reti
		
Representa:     out portb,encender
		ret




