`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: Alberto J. Molina Cantero
// 
// Create Date:    17:46:12 03/10/2012 
// Design Name: 
// Module Name:    UnidadDatos 
// Project Name: 
// Target Devices: 
// Tool versions: 
// Description: 
//
// Dependencies: 
//
// Revision: 
// Revision 0.01 - File Created
// Additional Comments: adaptado por Pilar Parra y Sergio Martin
//
//////////////////////////////////////////////////////////////////////////////////
module UnidadDatos(
   input clk , input wreg, wir, ipc, clpc, s, r, ta, tb,
   output [1:0] op
   );
   
   //sa es destino y sb es fuente
   wire [7:0] AluWire, AdressBus, DataBus;
   wire [2:0] sa, sb;

   reg [7:0] FileReg [7:0];  // FileReg es el fichero de registros
                             // Son los registros R7, R6, ..., R0.
      
   alutype alu (.ia(FileReg[sa]), .ib(FileReg[sb]),
                .s(s), .r(r), .ta(ta), .tb(tb), .out(AluWire));
   
   always @(posedge clk)
      if(wreg)
         FileReg[sa]<= AluWire;
         
   irtype regir (.in(DataBus),.out({op,sa,sb}),.w(wir),.clk(clk));
   pctype regpc (.out(AdressBus),.up(ipc),.cl(clpc),.clk(clk));
   romtype codmem (.adress(AdressBus), .data(DataBus));
   
   initial    // Cargamos valores inicales en algunos registros
      begin   // para que podamos ver algo interesante al simular.
         FileReg[0] = 8'h02; // R0 contiene 2 en decimal
         FileReg[1] = 8'h19; // R1 contiene 25 en decimal
         FileReg[4] = 8'h22; // R4 contiene 34 en decimal
         FileReg[6] = 8'h43; // R6 contiene 67 en decimal
      end
endmodule


module alutype (input [7:0] ia, input [7:0] ib, input s,r,ta,tb, output reg [7:0] out); 
   always @*
      casex({s,r,ta,tb})
         4'b1xxx: out = ia+ib;
         4'b01xx: out = ia-ib;
         4'b001x: out = ia;
         default: out = ib;
      endcase
endmodule

module irtype (input [7:0] in, input clk, output [7:0] out, input w);
   reg [7:0] q;
   always @(posedge clk)
      if(w)
         q <= in;
   assign out = q;
endmodule

module pctype (input clk, up, cl, output [7:0] out);
   reg [7:0] q;
   always @(posedge clk)
      if(cl)
         q <= 0;
      else
         if (up)
            q <= q+1;
   assign out = q;
endmodule

/***** Lea el comentario del final del fichero que   *****/
/***** muestra el formato de las instrucciones y los *****/
/***** codigos de operacion de cada una de ellas.    *****/

module romtype (input [7:0] adress, output reg [7:0] data);
   always @(adress)
      case(adress)
         0: data = 8'b01110100;     // MOV R6,R4
         1: data = 8'b10110001;     // SUB R6,R1
         // El programa esta incompleto.



         default:
            data=0;  // Por defecto hay un 0 en cada direccion de la ROM.  
      endcase
endmodule

/**********************************************************

   Formato de las instrucciones del CS1:
   
   +-------+-----------+-----------+ 
   |cod.op.| Rdestino  | Rfuente   |
   +-------+-----------+-----------+ 
   |co1|co0|d2 |d1 |d0 |f2 |f1 |f0 |
   +---+---+---+---+---+---+---+---+

   Codigo de operacion de las instrucciones del CS1:
   
   codop    instruccion
   -----    -----------
    00       ADD Rd,Rf
    10       SUB Rd,Rf
    01       MOV Rd,Rf
    11       STOP
         
**********************************************************/