`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: Alberto J. Molina Cantero
// 
// Create Date:    18:52:25 03/10/2012 
// Design Name: 
// Module Name:    UnidadControl 
// Project Name: 
// Target Devices: 
// Tool versions: 
// Description: 
//
// Dependencies: 
//
// Revision: 
// Revision 0.01 - File Created
// Additional Comments: adaptado por Pilar Parra y Sergio Martin
//
//////////////////////////////////////////////////////////////////////////////////
module UnidadControl(
   input clk, start, reset,
   output reg clpc, ipc, wir, wreg, s, r, ta, tb,  
   input [1:0] op
   );

   reg [1:0] state, next_state;
   
   parameter [1:0] S0=0, S1=1, S2=2;

   always @(posedge clk, posedge reset)
      if(reset)
         state <= S0;
      else
         state <= next_state;
         
   always @(state,start,op)
      begin
         {clpc, ipc, wir, wreg, s, r, ta, tb}=0;
         next_state=S0;
         case(state)
         S0: 
            if(start)
            begin
               clpc=1;
               next_state=S1;
            end	
         S1:
            begin
               wir=1;
               ipc=1;
               next_state=S2;
            end
         S2:
            begin
               next_state=S1;
               case(op)             // op[1:0] = IR[7:6]
               2'b00: begin         // Formato de instruccion del CS1:
                        wreg=1;     // op          instruccion
                        s=1;        // 00 dddfff   ADD Rd,Rf
                      end           // 01 dddfff   MOV Rd,Rf
               2'b01: begin         // 10 dddfff   SUB Rd,Rf
                        wreg=1;     // 11 ------   STOP
                        tb=1;
                      end
               2'b10: begin
                             
                        ta=1;
                      end
               2'b11: next_state=S0;
               endcase
            end
         endcase
      end

endmodule
