`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: Alberto J. Molina Cantero
// 
// Create Date:    17:46:12 03/10/2012 
// Design Name: 
// Module Name:    UnidadDatos 
// Project Name: 
// Target Devices: 
// Tool versions: 
// Description: Este fichero contiene la descripcin de la unidad de datos del
//     CS2. En la memoria de programa se ha cargado parte un programa cuya ejecucion
//     se puede comprobar en la simulacion.  
//
// Dependencies: 
//
// Revision: 
// Revision 0.01 - File Created
// Additional Comments: adaptado por Pilar Parra y Sergio Martin
//
//////////////////////////////////////////////////////////////////////////////////
module UnidadDatos(
   input clk,  output [4:0] op, 
   input wreg, wmem, rmem, wir, wmar, ipc, clpc, inm, rac, wac, s, r, ta, tb
   );
   
   //sa es destino y sb es fuente
   wire [7:0] AluWire, AddressBus, BusComp, AcWire, DataRam, AddressRam, MuxBus, ImmBus;
   wire [15:0] DataBus;
   reg [7:0] FileReg [7:0];  //Fichero de registros.
   wire [2:0] sa;
   wire [2:0] sb;
   
   muxtype mux(.canal0(FileReg[sb]), .canal1(ImmBus), .sel(inm), .sal(MuxBus));
   alutype alu (.ia(FileReg[sa]), .ib(MuxBus), .s(s), .r(r), .ta(ta), .tb(tb), .out(AluWire));
   actype  ac (.clk(clk), .w(wac), .r(rac), .in(AluWire), .out(BusComp));
   
   assign sb= ImmBus[2:0];
   
      
   always @(posedge clk)
      if(wreg)
         FileReg[sa]<= BusComp;
   
   irtype regir (.in(DataBus), .out({op,sa,ImmBus}), .w(wir), .clk(clk));
   pctype regpc (.out(AddressBus), .up(ipc), .cl(clpc), .clk(clk));
   romtype codmem (.adress(AddressBus), .data(DataBus));
   ramtype datamem (.address(AddressRam), .data(BusComp), .w(wmem), .r(rmem));
   martype mar (.clk(clk), .w(wmar), .in(BusComp), .out(AddressRam));
   
   
   initial       // Asignamos algunos valores iniciales de los registros
      begin      // para poder ver algo en el comienzo de la simulacion.
         FileReg[0] = 8'hFF;   // R0 vale 255 en decimal.
         FileReg[1] = 8'h0;    // El valor de R0 es muy importante si
         FileReg[2] = 8'h1;    // se ejecuta una zona de la memoria de
         FileReg[6] = 8'h0;    // codigo en la que haya un cero. Piense que
         FileReg[7] = 8'h2;    // instruccion es la 16'h0 y lo que hace.
      end
 

endmodule



module irtype (input [15:0] in, input clk, output [15:0] out, input w);
   reg [15:0] q;
   always @(posedge clk)
      if(w)
         q <= in;
   assign out = q;
endmodule

module pctype (input clk, up, cl, output [7:0] out);
   reg [7:0] q;
   always @(posedge clk)
      if(cl)
         q <= 0;
      else
         if (up)
            q <= q+1;
   assign out = q;
endmodule


module actype (input [7:0] in, input clk, r, w, output [7:0] out);
   reg [7:0] q;
   always @(posedge clk)
         if(w)
               q<= in;
   assign out = r ? q : 'bz;
endmodule


module martype(input clk, input [7:0] in , output [7:0] out , input w);
   reg [7:0] q;
   always @(posedge clk)
      if(w)
         q<= in;
   assign out=q;
endmodule


module alutype (input [7:0] ia, input [7:0] ib, input s,r,ta,tb, output reg [7:0] out); 
   always @*
      casex({s,r,ta,tb})
         4'b1xxx: out = ia+ib;
         4'b01xx: out = ia-ib;
         4'b001x: out = ia;
         default: out = ib;
      endcase
endmodule


module ramtype (input [7:0] address, inout [7:0] data, input r, w);
   reg [7:0] q [255:0];
   always @(*)
      if(w)
         q[address] <= data;
   
   assign data = (r & !w) ? q[address]: 'bz  ;
   
   // Valores iniciales de MEMDAT utiles solo para simulacion
   initial
      begin

         q[240]=40;
         q[241]=41;
         q[242]=42;
         q[243]=43;

         q[250]=50;
         q[251]=51;
         q[252]=52;
         q[253]=53;

      end   
endmodule


module muxtype(input [7:0] canal0, input [7:0] canal1, input sel, output [7:0] sal);
	assign sal = sel ? canal1 : canal0;
endmodule


/***** Lea el comentario del final del fichero que   *****/
/***** muestra el formato de las instrucciones y los *****/
/***** codigos de operacion de cada una de ellas.    *****/
module romtype (input [7:0] adress, output reg [15:0] data);
   always @(adress)
      case(adress)
      0  :  data = 16'b1111101000000001;  // LDI R2,1   Hace R2 <- 1
      1  :  data = 16'b1111111011110000;  // LDI Y,$F0  Hace R6 <- 240 (ya que Y es R6 y $F0 es 240)
      2  :  data = 16'b1111111111111010;  // LDI Z,$FA  Hace R7 <- 250 (ya que Z es R7 y $FA es 250)
      
      3  :  data = 16'b0000101100000110;  // LD R3,Y    Hace R3 <- MEMDAT(Y)
      4  :  data = 16'b0000110000000111;  // LD R4,Z    Hace R4 <- MEMDAT(Z)
      5  :  data = 16'b0000001100000111;  // ST Z,R3    Hace MEMDAT(Z) <- R3
      6  :  data = 16'b0000010000000110;  // ST Y,R4    Hace MEMDAT(Y) <- R4
                                          //            Tras eso ya se han intercambiado 2 elementos.
                                          
      7  :  data = 16'b0100011000000010;  // ADD Y,R2   Hace Y <- Y + R2 (Incrementa Y, pues R2 es 1)
      8  :  data = 16'b0100011100000010;  // ADD Z,R2   Hace Z <- Z + R2 (Incrementa Z, pues R2 es 1)
                                          //            Ahora los punteros Y y Z apuntan al segundo dato.
      
      9  :  data = 16'b0000101100000110;  // LD R3,Y    Hace R3 <- MEMDAT(Y)
      10 :  data = 16'b0000110000000111;  // LD R4,Z    Hace R4 <- MEMDAT(Z)
      11 :  data = 16'b0000001100000111;  // ST Z,R3    Hace MEMDAT(Z) <- R3
      12 :  data = 16'b0000010000000110;  // ST Y,R4    Hace MEMDAT(Y) <- R4
                                          //            Tras eso ya se han intercambiado 4 elementos.
                                          
      13 :  data = 16'b0100011000000010;  // ADD Y,R2   Hace Y <- Y + R2 (Incrementa Y, pues R2 es 1)
      14 :  data = 16'b0100011100000010;  // ADD Z,R2   Hace Z <- Z + R2 (Incrementa Z, pues R2 es 1)
                                          //            Ahora los punteros Y y Z apuntan al tercer dato.
                                          
      15 :  data = 16'b0000101100000110;  // LD R3,Y    Hace R3 <- MEMDAT(Y)
      16 :  data = 16'b0000110000000111;  // LD R4,Z    Hace R4 <- MEMDAT(Z)
      17 :  data = 16'b0000001100000111;  // ST Z,R3    Hace MEMDAT(Z) <- R3
      18 :  data = 16'b0000010000000110;  // ST Y,R4    Hace MEMDAT(Y) <- R4
                                          //            Tras eso ya se han intercambiado 6 elementos.
                                          
      19 :  data = 16'b0100011000000010;  // ADD Y,R2   Hace Y <- Y + R2 (Incrementa Y, pues R2 es 1)
      
      // El programa que hay en la memoria ROM (la memoria de codigo)
      // esta INCOMPLETO, por lo que debe rellenar lo que falta.










        default: data=0;  // Por defecto las posiciones de la ROM no especificadas se ponen a 0.
     endcase
endmodule

/*********************************************************************

El formato de instruccion del CS2 empieza
con un codigo de operacion de 5 bits y le
siguen 11 bits que indican los operandos, con
una estructura que depende del tipo de instruccion.
Un "-" inidca que ese bit no importa.
Y y Z son registros "base": Y es R6 y Z es R7.

Formato de las 10 instrucciones del CS2:

codop  operandos      Instruccion
===== ===========    ========================
00000 fff-----bas    ST Y,Rf  o bien  ST Z,Rf      (bas=110 o bas=111)
00001 ddd-----bas    LD Rd,Y  o bien  LD Rd,Z      (bas=110 o bas=111)
00010 fffaaaaaaaa    STS direccion,Rf      (aaaaaaaa=direccion 8 bits)
00011 dddaaaaaaaa    LDS Rd,direccion      (aaaaaaaa=direccion 8 bits)
11111 dddvvvvvvvv    LDI Rd,dato             (vvvvvvvv=dato de 8 bits)
01000 ddd-----fff    ADD Rd,Rf
01010 ddd-----fff    SUB Rd,Rf
11010 dddvvvvvvvv    SUBI Rd,dato            (vvvvvvvv=dato de 8 bits)
01111 ddd-----fff    MOV Rd,Rf
10111 -----------    STOP

*********************************************************************/

