`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: Albeto J. Molina Cantero
// 
// Create Date:    18:52:25 03/10/2012 
// Design Name: 
// Module Name:    UnidadControl 
// Project Name: 
// Target Devices: 
// Tool versions: 
// Description: 
//
// Dependencies: 
//
// Revision: 
// Revision 0.01 - File Created
// Additional Comments: adaptado por Pilar Parra y Sergio Martin
//
//////////////////////////////////////////////////////////////////////////////////
module UnidadControl(
   input clk, start, reset, 
   input [4:0] op, 
   output reg wmem, rmem, clpc, ipc, wir, wmar, inm, wreg, rac, wac, s, r, ta, tb
   );

   reg [3:0] state, next_state;

   // Estos son los codigos de operacion de 5 bits de
   // las 10 instrucciones del CS2, puestos en orden ascendente.
   parameter [4:0]
      Ins_ST   = 5'b00000,
      Ins_LD   = 5'b00001,
      Ins_STS  = 5'b00010,
      Ins_LDS  = 5'b00011,
      Ins_ADD  = 5'b01000,
      Ins_SUB  = 5'b01010,
      Ins_MOV  = 5'b01111,
      Ins_STOP = 5'b10111,
      Ins_SUBI = 5'b11010,
      Ins_LDI  = 5'b11111;
    
   // Estos son los 11 estados de la carta ASM del CS2.
   // Cada estado tiene asignado un codigo de 4 bits.
   // Aclaracion: S8_Execute_3_LD quiere decir que el estado 8
   //             de la carta ASM es el tercer estado de la
   //             fase de ejecucion de la instruccion LD.
   parameter [3:0]
       S0_Stop            = 0, 
       S1_Fetch           = 1,
       S2_Execute_1_All   = 2,
       S3_Execute_2_opreg = 3,
       S4_Execute_2_LDS   = 4,
       S5_Execute_3_LDS   = 5,
       S6_Execute_2_STS   = 6,
       S7_Execute_3_STS   = 7,
       S8_Execute_2_LD    = 8,
       S9_Execute_3_LD    = 9,
      S10_Execute_2_ST    = 10,
      S11_Execute_3_ST    = 11; 
                   
   always @(posedge clk, posedge reset)
      if(reset)
         state <= S0_Stop;
      else
         state <= next_state;
         
   always @(*)
      begin
         {clpc,ipc,inm,wmar,rmem,wmem,wir,rac,wac,wreg,s,r,ta,tb}=0;
         next_state=S0_Stop;
         case(state)
         S0_Stop:  //Estado de espera inicial
            if(start)
               begin
                  clpc=1;  //PC <- 0
                  next_state=S1_Fetch;
               end
         S1_Fetch: //Ciclo de Fetch
            begin
               wir=1;  // IR <- CODMEM(PC)
               ipc=1;  // PC <- PC+1
               next_state=S2_Execute_1_All;
            end
         S2_Execute_1_All: // Estado de la fase de ejecucion compartido por todas.                          
            begin          // Se consulta "op" (codigo de operacion) y se bifurca.
               case(op)
               Ins_STOP: 
                     next_state = S0_Stop;   // Termina el programa
               Ins_ADD: 
                  begin
                     wac=1;
                     s=1;     // AC <- REG[sa]+REG[sb]
                     next_state=S3_Execute_2_opreg;
                  end
               Ins_SUB:
                  begin
                     wac=1;
                     r=1;     // AC <- REG[sa]-REG[sb]
                     next_state=S3_Execute_2_opreg;
                  end
               Ins_SUBI:
                  begin
                     wac=1;
                     r=1;
                     inm=1;   // AC <- REG[sa]-IR[7:0]
                     next_state=S3_Execute_2_opreg;
                  end
               Ins_MOV:
                  begin
                     ta=1;
                     wac=1;   //AC <- REG[sa]
                     next_state=S3_Execute_2_opreg;
                  end
               Ins_LDI:
                  begin
                     wac=1;
                     tb=1;
                     inm=1;   //AC <- IR[7:0] dato inmediato
                     next_state=S3_Execute_2_opreg;
                  end
               Ins_LDS:
                  begin
                     wac=1;
                     tb=1;
                     inm=1;   //AC <- IR[7:0] dirección
                     next_state=S4_Execute_2_LDS;
                  end
               Ins_STS:
                  begin
                     wac=1;
                     tb=1;
                     inm=1;   //AC <- IR[7:0] dirección
                     next_state=S6_Execute_2_STS;
                  end
               Ins_LD:
                  begin
                     wac=1;   //AC <- REG[sb]
                     tb=1;
                     next_state=S8_Execute_2_LD;
                  end
               Ins_ST:
                  begin
                     wac=1;
                     tb=1;    //AC <- REG[sb]
                     next_state=S10_Execute_2_ST;
                  end             
               default: next_state=S0_Stop;  // Esto no deberia ocurrir
               endcase // Fin del case que consulta el valor de "op"
            end
         S3_Execute_2_opreg:  // Segundo estado de ejecucion de las instruciones
            begin             // de tipo "opreg", que son: ADD,SUB,MOV,LDI y SUBI.
               wreg=1;        // AC ya contiene el dato a escribir en el registro.
               rac=1;         //REG[sa] <- AC
               next_state=S1_Fetch;
            end           
         S4_Execute_2_LDS:    // Segundo estado en la ejecucion de LDS.
            begin             // AC ya contiene la direccion.
               wmar=1;
               rac=1;         // MAR <- AC
               next_state=S5_Execute_3_LDS;
            end
         S5_Execute_3_LDS:
            begin
               wreg=1;
               rmem=1;        // REG[sa] <- MEMDAT[MAR]
               next_state=S1_Fetch;
            end
         S6_Execute_2_STS:    // Segundo estado en la ejecucion de STS.
            begin             // AC ya contiene la direccion.
               rac=1;  
               wmar=1;        // MAR <- AC
               wac=1; 
               ta=1;          // AC <- REG[sa]
               next_state=S7_Execute_3_STS;
            end
         S7_Execute_3_STS:
            begin
               rac=1;
               wmem=1;        // MEMDAT[MAR] <- AC
               next_state=S1_Fetch;
            end
         S8_Execute_2_LD:     // Segundo estado en la ejecucion de LD.
            begin             // AC ya contiene la direccion.
               wmar=1;
               rac=1;         // MAR <- AC
               next_state=S9_Execute_3_LD;
            end
         S9_Execute_3_LD:
            begin
               wreg=1;  
               rmem=1;        // REG[sa] <- MEMDAT[MAR]
               next_state=S1_Fetch;
            end
         S10_Execute_2_ST:    // Segundo estado en la ejecucion de ST.
            begin             // AC ya contiene la direccion.
               wmar=1;
               rac=1;         // MAR <- AC
               wac=1;         // AC <- REG[sa]
               ta=1; 
               next_state=S11_Execute_3_ST;
            end
         S11_Execute_3_ST:
            begin
               rac=1;         // MEMDAT[MAR] <- AC
               wmem=1;
               next_state=S1_Fetch;
            end           
         default: next_state=S0_Stop;  // Esto no deberia ocurrir
         endcase  // Fin del case que consulta el valor de "state"      
      end
endmodule

/*********************************************************************

El formato de instruccion del CS2 empieza
con un codigo de operacion de 5 bits y le
siguen 11 bits que indican los operandos, con
una estructura que depende del tipo de instruccion.
Un "-" inidca que ese bit no importa.
Y y Z son registros "base": Y es R6 y Z es R7.

Formato de las 10 instrucciones del CS2:

codop  operandos      Instruccion
===== ===========    ========================
00000 fff-----bas    ST Y,Rf  o bien  ST Z,Rf      (bas=110 o bas=111)
00001 ddd-----bas    LD Rd,Y  o bien  LD Rd,Z      (bas=110 o bas=111)
00010 fffaaaaaaaa    STS direccion,Rf      (aaaaaaaa=direccion 8 bits)
00011 dddaaaaaaaa    LDS Rd,direccion      (aaaaaaaa=direccion 8 bits)
11111 dddvvvvvvvv    LDI Rd,dato             (vvvvvvvv=dato de 8 bits)
01000 ddd-----fff    ADD Rd,Rf
01010 ddd-----fff    SUB Rd,Rf
11010 dddvvvvvvvv    SUBI Rd,dato            (vvvvvvvv=dato de 8 bits)
01111 ddd-----fff    MOV Rd,Rf
10111 -----------    STOP

*********************************************************************/



