/* El programa principal carga en r21 el valor que deseamos
   elevar al cubo y luego llama a la subrutina cubo.
   Tras eso, mueve el resultado desde r20 al registro r0.
*/
         ldi r21,3   ; Vamos a calcular el cubo de 3
         call cubo
         mov r0,r20
fin:     jmp fin     ; Bucle infinito, simula el STOP

/* La subrutina cubo escrita a continuacion calcula el cubo 
   del dato que este cargado en r21 y lo almacena en r20
        r20 <- r21^3
   Para ello, eleva al cuadrado el valor de r21 usando la
   subrutina mult y el resultado lo multiplica otra vez por
   el valor de r21, usando de nuevo la subrutina mult.
   Durante el proceso, el registro r22 acaba valiendo 0,
   por lo que se pierde cualquier valor que pudiera tener.
*/
cubo:    mov r22,r21
         call mult      ; r20 <- r21 x r22
         mov r22,r20
         call mult      ; r20 <- r21 x r22
         ret

/* La subrutina mult escrita a continuacion calcula
   el producto de r21 y r22 y lo almacena en r20.
         r20 <- r21 x r22
   Durante el proceso, el registro r22 acaba valiendo 0,
   por lo que se pierde cualquier valor que pudiera tener.
*/
mult:    ldi r20,0
         cpi r22,0
bucle:   breq retorna
         add r20,r21
         subi r22,1
         jmp bucle
retorna: ret
