// Design: display
// Description: Digilent's Basys2 7-segmen display tester
// Author: Jorge Juan <jjchico@dte.us.es>
// Copyright Universidad de Sevilla, Spain
// Date: 12-11-2011

////////////////////////////////////////////////////////////////////////////////                                                                         //
// This file is free software: you can redistribute it and/or modify it under //
// the terms of the GNU General Public License as published by the Free       //
// Software Foundation, either version 3 of the License, or (at your option)  //
// any later version. You can access a copy of the GNU General Public License //
// at <http://www.gnu.org/licenses/>.                                         //
////////////////////////////////////////////////////////////////////////////////

`timescale 1ns / 1ps

// Base time to easy simulation control
`define BTIME 10

module test();

	// Inputs
	reg [3:0] d;
	reg [3:0] sel;

	// Output
	wire [1:7] seg;
	wire [3:0] an;

	// UUT instance
	display uut (.d(d), .sel(sel), .seg(seg), .an(an));

	// Input initialization and simulation control
	initial begin
		// 'd' is initiated to '0' and 'sel' to '1010'
		d = 0;
		sel = 4'b1010;

		// Waveform generation statements
		// $dumpfile("test.vcd");
		// $dumpvars(0,test);

		// Results printing
		$display("d\tsel\tseg\tan");
		$monitor("%d\t%b\t%b\t%b", d, sel, seg, an);

		// Simulation end after 16 ciclyes
		#(16*`BTIME) $finish;
	end

	// Input pattern generation
	always
		#(`BTIME) d = d + 1;

endmodule // test
